/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.forge.blocks;

import com.fizzware.dramaticdoors.forge.blocks.ShortDoorBlock;
import com.fizzware.dramaticdoors.forge.state.properties.DDBlockStateProperties;
import com.fizzware.dramaticdoors.forge.state.properties.Orientation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ShortFullFleshDoorBlock
extends ShortDoorBlock {
    public static final EnumProperty<Orientation> ORIENTATION = DDBlockStateProperties.ORIENTATION;
    public static final int USE_UPDATE_FLAG = 10;
    protected static final int THICKNESS = 2;
    protected static final int CLOSED_SHAPE_INDEX = 0;
    protected static final int OPEN_SHAPE_INDEX = 1;
    protected static final VoxelShape[] X_NEG_AABB = ShortFullFleshDoorBlock.createClosedAndOpenShape(0.0, 0.0, 0.0, 2.0, 16.0, 16.0);
    protected static final VoxelShape[] X_NONE_AABB = ShortFullFleshDoorBlock.createClosedAndOpenShape(7.0, 0.0, 0.0, 9.0, 16.0, 16.0);
    protected static final VoxelShape[] X_POS_AABB = ShortFullFleshDoorBlock.createClosedAndOpenShape(14.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape[] Z_NEG_AABB = ShortFullFleshDoorBlock.createClosedAndOpenShape(0.0, 0.0, 0.0, 16.0, 16.0, 2.0);
    protected static final VoxelShape[] Z_NONE_AABB = ShortFullFleshDoorBlock.createClosedAndOpenShape(0.0, 0.0, 7.0, 16.0, 16.0, 9.0);
    protected static final VoxelShape[] Z_POS_AABB = ShortFullFleshDoorBlock.createClosedAndOpenShape(0.0, 0.0, 14.0, 16.0, 16.0, 16.0);

    public ShortFullFleshDoorBlock(Block from) {
        super(from);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(ORIENTATION, (Comparable)((Object)Orientation.X_MIDDLE)));
    }

    private static VoxelShape[] createClosedAndOpenShape(double x0, double y0, double z0, double x1, double y1, double z1) {
        VoxelShape closedShape = Block.m_49796_((double)x0, (double)y0, (double)z0, (double)x1, (double)y1, (double)z1);
        boolean caseX = x0 == 0.0 && x1 == 16.0;
        boolean caseZ = z0 == 0.0 && z1 == 16.0;
        double offset = 2.0;
        double xAL = caseX ? x0 + offset : x0;
        double zAL = caseZ ? z0 + offset : z0;
        double xBL = caseX ? x1 : x1;
        double zBL = caseZ ? z1 : z1;
        double xAR = caseX ? x0 : x0;
        double zAR = caseZ ? z0 : z0;
        double xBR = caseX ? x1 - offset : x1;
        double zBR = caseZ ? z1 - offset : z1;
        VoxelShape openShapeLeft = Shapes.m_83113_((VoxelShape)closedShape, (VoxelShape)Block.m_49796_((double)xAL, (double)(y0 + offset), (double)zAL, (double)xBL, (double)(y1 - offset), (double)zBL), (BooleanOp)BooleanOp.f_82687_);
        VoxelShape openShapeRight = Shapes.m_83113_((VoxelShape)closedShape, (VoxelShape)Block.m_49796_((double)xAR, (double)(y0 + offset), (double)zAR, (double)xBR, (double)(y1 - offset), (double)zBR), (BooleanOp)BooleanOp.f_82687_);
        VoxelShape openShapeForCollisionLeft = Shapes.m_83113_((VoxelShape)closedShape, (VoxelShape)Block.m_49796_((double)xAL, (double)y0, (double)zAL, (double)xBL, (double)y1, (double)zBL), (BooleanOp)BooleanOp.f_82687_);
        VoxelShape openShapeForCollisionRight = Shapes.m_83113_((VoxelShape)closedShape, (VoxelShape)Block.m_49796_((double)xAR, (double)y0, (double)zAR, (double)xBR, (double)y1, (double)zBR), (BooleanOp)BooleanOp.f_82687_);
        return new VoxelShape[]{closedShape, openShapeLeft, openShapeRight, openShapeForCollisionLeft, openShapeForCollisionRight};
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        if (pos.m_123342_() >= level.m_151558_() || !level.m_8055_(pos).m_60629_(context)) {
            return null;
        }
        BlockState state = this.m_49966_();
        if (!context.m_7058_()) {
            Orientation orientation = Orientation.getXZOrientationFrom(context);
            state = (BlockState)state.m_61124_(ORIENTATION, (Comparable)((Object)orientation));
        } else {
            boolean isXAxis = context.m_8125_().m_122434_() == Direction.Axis.X;
            state = (BlockState)state.m_61124_(ORIENTATION, (Comparable)((Object)(isXAxis ? Orientation.X_MIDDLE : Orientation.Z_MIDDLE)));
        }
        if (level.m_46753_(pos) || level.m_46753_(pos.m_7494_())) {
            state = (BlockState)((BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true));
        }
        state = (BlockState)state.m_61124_((Property)HINGE, (Comparable)this.getHinge(context));
        if (context.m_8125_() == Direction.WEST || context.m_8125_() == Direction.SOUTH) {
            state = (BlockState)state.m_61122_((Property)HINGE);
        }
        if (level.m_6425_(pos).m_76152_() == Fluids.f_76193_) {
            state = (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @Override
    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
    }

    @Override
    protected DoorHingeSide getHinge(BlockPlaceContext pContext) {
        Level blockgetter = pContext.m_43725_();
        BlockPos blockpos = pContext.m_8083_();
        Direction direction = pContext.m_8125_();
        BlockPos blockpos1 = blockpos.m_7494_();
        Direction direction1 = direction.m_122428_();
        BlockPos blockpos2 = blockpos.m_121945_(direction1);
        BlockState blockstate = blockgetter.m_8055_(blockpos2);
        BlockPos blockpos3 = blockpos1.m_121945_(direction1);
        BlockState blockstate1 = blockgetter.m_8055_(blockpos3);
        Direction direction2 = direction.m_122427_();
        BlockPos blockpos4 = blockpos.m_121945_(direction2);
        BlockState blockstate2 = blockgetter.m_8055_(blockpos4);
        BlockPos blockpos5 = blockpos1.m_121945_(direction2);
        BlockState blockstate3 = blockgetter.m_8055_(blockpos5);
        int i = (blockstate.m_60838_((BlockGetter)blockgetter, blockpos2) ? -1 : 0) + (blockstate1.m_60838_((BlockGetter)blockgetter, blockpos3) ? -1 : 0) + (blockstate2.m_60838_((BlockGetter)blockgetter, blockpos4) ? 1 : 0) + (blockstate3.m_60838_((BlockGetter)blockgetter, blockpos5) ? 1 : 0);
        boolean flag = blockstate.m_60713_((Block)this);
        boolean flag1 = blockstate2.m_60713_((Block)this);
        if ((!flag || flag1) && i <= 0) {
            if ((!flag1 || flag) && i >= 0) {
                int j = direction.m_122429_();
                int k = direction.m_122431_();
                Vec3 vec3 = pContext.m_43720_();
                double d0 = vec3.f_82479_ - (double)blockpos.m_123341_();
                double d1 = vec3.f_82481_ - (double)blockpos.m_123343_();
                return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int idx;
        int offset = 0;
        int n = idx = this.isOpen(state) ? 1 + offset : 0;
        if (this.isOpen(state)) {
            idx += state.m_61143_((Property)HINGE) == DoorHingeSide.LEFT ? 0 : 1;
        }
        return switch ((Orientation)((Object)state.m_61143_(ORIENTATION))) {
            case Orientation.X_POSITIVE -> X_POS_AABB[idx];
            case Orientation.X_MIDDLE -> X_NONE_AABB[idx];
            case Orientation.X_NEGATIVE -> X_NEG_AABB[idx];
            case Orientation.Z_POSITIVE -> Z_POS_AABB[idx];
            case Orientation.Z_MIDDLE -> Z_NONE_AABB[idx];
            case Orientation.Z_NEGATIVE -> Z_NEG_AABB[idx];
            default -> Shapes.m_83144_();
        };
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int idx;
        int n = idx = this.isOpen(state) ? 3 : 0;
        if (this.isOpen(state)) {
            idx += state.m_61143_((Property)HINGE) == DoorHingeSide.LEFT ? 0 : 1;
        }
        return switch ((Orientation)((Object)state.m_61143_(ORIENTATION))) {
            case Orientation.X_POSITIVE -> X_POS_AABB[idx];
            case Orientation.X_MIDDLE -> X_NONE_AABB[idx];
            case Orientation.X_NEGATIVE -> X_NEG_AABB[idx];
            case Orientation.Z_POSITIVE -> Z_POS_AABB[idx];
            case Orientation.Z_MIDDLE -> Z_NONE_AABB[idx];
            case Orientation.Z_NEGATIVE -> Z_NEG_AABB[idx];
            default -> Shapes.m_83144_();
        };
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND, PathComputationType.AIR -> this.isOpen(state);
            case PathComputationType.WATER -> false;
        };
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ORIENTATION});
    }

    @Override
    public BlockState m_6843_(BlockState state, Rotation rotationDirection) {
        Orientation orientation = (Orientation)((Object)state.m_61143_(ORIENTATION));
        return (BlockState)state.m_61124_(ORIENTATION, (Comparable)((Object)orientation.rotate(rotationDirection)));
    }

    @Override
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        Orientation orientation = (Orientation)((Object)state.m_61143_(ORIENTATION));
        return (BlockState)state.m_61124_(ORIENTATION, (Comparable)((Object)orientation.mirror(mirror)));
    }
}

